#!/bin/bash

# Güncellemeler
echo "Sistem güncellemeleri yapılıyor..."
sudo apt update && sudo apt upgrade -y
#echo "Güncellemeler tamamlandı."

# Uygulama listesi
apps=(
    "onlyoffice-desktopeditors"
    "libreoffice"
    "google-chrome-stable"
    "sublime-text"
    "vlc"
    "smplayer"
    "anydesk"
    "rustdesk"
    "flameshot"
    "brave-browser"
    "okular"
    "gimp"
    "pinta"
    "teams"
    "zoom"
    "zotero"
    "p7zip"
    "simple-scan"
)

# Yüklenemeyen uygulamaları saklamak için bir liste
failed_apps=()

# Her uygulama için kontrol ve yükleme işlemi
for app in "${apps[@]}"; do
    # Uygulamanın yüklü olup olmadığını kontrol et
    if ! dpkg -l | grep -q "$app"; then
        echo "$app yüklü değil, yüklemeye çalışılıyor..."

        # AppCenter'da uygulamayı ara ve yükle
        if pisi search "$app" | grep -q "$app"; then
            echo "$app AppCenter'da bulundu, yükleniyor..."
            sudo pisi it "$app" || failed_apps+=("$app")
        else
            echo "$app AppCenter'da bulunamadı, apt ile yükleniyor..."
            sudo apt install -y "$app" || failed_apps+=("$app")
        fi
    else
        echo "$app zaten yüklü."
    fi
done

# Java kurulum gereksinimini kontrol etme
if ! java -version &>/dev/null; then
    echo "Java yüklü değil, yükleniyor..."
    sudo apt install default-jre -y&& sudo apt install default-jdk -y 
    echo "Java kurulumu tamamlandı."
else
    echo "Java zaten yüklü."
fi

# Aynı klasördeki .deb dosyalarını yükle
echo "Aynı klasördeki .deb dosyaları yükleniyor..."
deb_failed_apps=()
for deb_file in ./*.deb; do
    if [ -f "$deb_file" ]; then
        echo "$deb_file yükleniyor..."
        sudo dpkg -i "$deb_file" || deb_failed_apps+=("$deb_file")
        sudo apt-get install -f -y  # Bağımlılıkları otomatik tamamlama
    fi
done


# GLPI Agent Kurulumu
sudo apt install libfuse2
echo "GLPI Agent indiriliyor ve kuruluyor..."
wget https://github.com/glpi-project/glpi-agent/releases/download/1.11/glpi-agent-1.11-x86_64.AppImage -O glpi-agent-1.11-x86_64.AppImage
chmod +x glpi-agent-1.11-x86_64.AppImage
sudo ./glpi-agent-1.11-x86_64.AppImage --install --server https://destek.igdir.edu.tr/
sudo glpi-agent

if systemctl status glpi-agent | grep -q "active (running)"; then
    echo "GLPI Agent başarıyla kuruldu ve çalışıyor."
else
    echo "GLPI Agent kurulumu başarısız veya çalışmıyor."
fi


# Yüklenemeyen uygulamaları raporla
if [ ${#failed_apps[@]} -gt 0 ]; then
    echo "Yüklenemeyen uygulamalar:"
    for app in "${failed_apps[@]}"; do
        echo "- $app"
    done
else
    echo "Tüm uygulamalar başarıyla yüklendi."
fi

echo "Tüm işlemler tamamlandı."

