#!/bin/bash

# Kullanıcı bilgilerini alma
CURRENT_USER=$(whoami)
CURRENT_GROUP=$(id -gn $CURRENT_USER)

# Hedef dizin
TARGET_DIR="/usr/local/3ArtiEbysSigner"
JDK_DIR="/usr/lib/jvm/java-8-openjdk-amd64"
JRE_LINK="$TARGET_DIR/jre"
OLD_CACERTS_LINK="$JRE_LINK/lib/security/cacerts"

# Sembolik link oluşturma
if [ ! -L "$JRE_LINK" ]; then
    echo "JRE için sembolik link oluşturuluyor..."
    ln -s "$JDK_DIR/jre" "$JRE_LINK"
    if [ $? -eq 0 ]; then
        echo "Sembolik link başarıyla oluşturuldu."

	# Eski cacerts sembolik linkini yeniden adlandırma
	if [ -L "$OLD_CACERTS_LINK" ]; then
	    echo "Eski cacerts sembolik linki mevcut, yeniden adlandırılıyor..."
	    mv "$OLD_CACERTS_LINK" "$OLD_CACERTS_LINK.old"
	    if [ $? -eq 0 ]; then
	        echo "Eski cacerts sembolik linki başarıyla yeniden adlandırıldı."
	    else
	        echo "Eski cacerts sembolik linki yeniden adlandırılamadı."
	        exit 1
	    fi
	else
	    echo "Eski cacerts sembolik linki mevcut değil."
	fi
    else
        echo "Sembolik link oluşturma başarısız oldu."
        exit 1
    fi
else
    echo "JRE için sembolik link zaten mevcut."
fi

# Dizin ve içindeki dosyaların sahibi ve grubunu değiştirme
chown -R $CURRENT_USER:$CURRENT_GROUP "$TARGET_DIR"

# Servisi varsayılan runlevel'larda etkinleştir
echo "Servis varsayılan runlevel'larda etkinleştiriliyor..."
sudo update-rc.d 3ArtiEbysSigner defaults

# Servisi başlat
echo "Servis başlatılıyor..."
sudo service 3ArtiEbysSigner start
start_status=$?

# Kurulum tamamlandığını bildiren mesaj
if [ $start_status -eq 0 ]; then
    if command -v zenity &>/dev/null; then
        zenity --info --text="Kurulum tamamlandı ve servis başlatıldı."
    else
        echo "Kurulum tamamlandı ve servis başlatıldı."
    fi
else
    if command -v zenity &>/dev/null; then
        zenity --error --text="Kurulum sırasında bir hata oluştu."
    else
        echo "Kurulum sırasında bir hata oluştu."
    fi
fi

exit 0
