#!/bin/bash

# Servisi durdur
echo "Servis durduruluyor..."
sudo service 3ArtiEbysSigner stop
stop_status=$?

# Java işlemini sonlandır
JAVA_PROCESS_ID=$(pgrep -f "job.jar")
if [ -n "$JAVA_PROCESS_ID" ]; then
    echo "Java işlem sonlandırılıyor: $JAVA_PROCESS_ID"
    kill -9 $JAVA_PROCESS_ID
    sleep 5 # Java işlemi sonlandıktan sonra biraz bekle
else
    echo "Java işlemi bulunamadı."
fi

# Servisi tekrar başlat
echo "Servis tekrar başlatılıyor..."
sudo service 3ArtiEbysSigner start
start_status=$?

# Durumu kontrol et
if [ $stop_status -eq 0 ] && [ $start_status -eq 0 ]; then
    echo "Servis başarıyla yeniden başlatıldı."
else
    echo "Servis başlatılırken veya durdurulurken bir hata oluştu. Durum kodları: $stop_status (durdur), $start_status (başlat)"
fi

exit $start_status

