#!/bin/bash

# Güncellemeler
echo "Sistem güncellemeleri yapılıyor..."
#sudo apt update && sudo apt upgrade -y
#echo "Güncellemeler tamamlandı."

# Uygulama listesi
apps=(
    "onlyoffice-desktopeditors"
    "libreoffice"
    "google-chrome-stable"
    "sublime-text"
    "vlc"
    "smplayer"
    "anydesk"
    "rustdesk"
    "flameshot"
    "brave-browser"
    "okular"
    "gimp"
    "pinta"
    "teams"
    "zoom"
    "zotero"
    "p7zip"
    "simple-scan"
)

# Yüklenemeyen uygulamaları saklamak için bir liste
failed_apps=()

# Her uygulama için kontrol ve yükleme işlemi
for app in "${apps[@]}"; do
    # Uygulamanın yüklü olup olmadığını kontrol et
    if ! dpkg -l | grep -q "$app"; then
        echo "$app yüklü değil, yüklemeye çalışılıyor..."

        # AppCenter'da uygulamayı ara ve yükle
        if pisi search "$app" | grep -q "$app"; then
            echo "$app AppCenter'da bulundu, yükleniyor..."
            sudo pisi it "$app" || failed_apps+=("$app")
        else
            echo "$app AppCenter'da bulunamadı, apt ile yükleniyor..."
            sudo apt install -y "$app" || failed_apps+=("$app")
        fi
    else
        echo "$app zaten yüklü."
    fi
done

# Yüklenemeyen uygulamaları raporla
if [ ${#failed_apps[@]} -gt 0 ]; then
    echo "Yüklenemeyen uygulamalar:"
    for app in "${failed_apps[@]}"; do
        echo "- $app"
    done
else
    echo "Tüm uygulamalar başarıyla yüklendi."
fi

echo "Tüm işlemler tamamlandı."

